(
	-- Blend Material

	struct AMGData 
	(
		-- Compute absorption
		fn getAbsorb mtl =
		(
			-- Not a physical material? Doesn't absorb
			if mtl.classid as string != PhysicalMaterial.classid as string do
				return (color 0 0 0)
			-- Material not set for absorbing anything? 
			if mtl.transparency == 0.0 or mtl.trans_depth == 0 or mtl.thin_walled == true do
				return (color 0 0 0)

			-- Convert max color 0-255 to 0.0 - 1.0
			local tcol = mtl.trans_color / 255.0
			-- Apply same math as the shader would have done
			local dinv = (-0.43 / mtl.trans_depth) 
			tcol.r =  (log tcol.r) * dinv 
			tcol.g = (log tcol.g) * dinv
			tcol.b = (log tcol.b) * dinv
			-- turn back to 0-255 space
			tcol *= 255.0
			-- Return the value
			return tcol
		),
		
		fn GetUUID mtl context =
		(
			"c0a9d104-c110-49f9-8cf7-82171c872bdd"
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			append res #("Mtl1", mtl.map1, "material")
			append res #("Mtl2", mtl.map2, "material")

			if mtl.mask != undefined and mtl.maskEnabled do 
				append res #("Blend", mtl.mask, "resultFloat")

			res
		),

		fn GetParams mtl context =
		(
			local res = #()	

			-- In "percent", so divide by 100....
			append res #("Blend",      mtl.mixAmount / 100.0)

			if (mtl.maskEnabled) do (
				append res #("UseCurve",   mtl.useCurve)
				append res #("Low",        mtl.lower)
				append res #("High",       mtl.upper)
			)

			-- Add the absorptions from the 2 sub materials
			local absorb = getAbsorb(mtl.map1)
			absorb += getAbsorb(mtl.map2)						
			append res #("absorption", absorb)

			res
		)
	)
	
	AMGData()
)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCHGArnZmNVDeDr95qedkSVDkFxBTRF/nMz
-- L9vjkWpfXHiFr6zBDteFlTFPd2SNkBDk7CAvu6Z582MoojMpDEzw17HiMbFnzghI
-- 6bG7gk5yFJh99LH73Zcr+61D98dlKAnaPM3pAaOejT7fF5v5aonW4xvktz/AHFrO
-- MaHm/ym06FV43EMzWymsYhG/8Yc7hbFkv4xglM6hCzMLq//fGprdtFRUzJW5cyP+
-- 8DrdWcIe1f2wfY4VND7LCJ5MQdq+k0rm9Xdd7ozC5BRaUJJ6VY9pUyJhLvCmEMoD
-- p0aFnIBVJANSqPq/qUj9JTfKe+IZLh06fNEtbrFw2VtI+Y99RufN
-- -----END-SIGNATURE-----